function [Mxx,Nxx] = bfor_endogenous_ms_solver_matrices_xx(nderivs, Pmatss, H, G)
% 
% Returns the matrices Mxx and Nxx for solving the second order derivative
%   with respect to xlag, xlag
% 
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
%  INPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  Pmatss   = (ns x ns) matrix of the transition matrix at steady state
%  H        = (nx x (nx+ne+1) x ns) array for first-order solution for the 
%               predetermined variables, H(i,j,s) is the response of x(i) 
%               to state(j) given regime s, state=[xlag;epsilon;chi]
%  G        = (ny x (nx+ne+1) x ns) array for first-order solution for the 
%               non-predetermined variables, G(i,j,s) is the response of 
%               y(i) to state(j) given regime s, state=[xlag;epsilon;chi]
%  
%  OUTPUTS
%   Mxx     = {ns x ns) cell of derivative coefficients for solving the
%               system
%   Nxx     = {ns x ns) cell of constants for solving the system
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% -- Other Setup -- %
ny  = size(G,1);
nx  = size(H,1);
ns  = length(Pmatss);
n   = nx + ny;
Mxx = cell(ns,ns);
Nxx = cell(ns,ns);

dPy = nderivs.dPy;

for s = 1:ns
    for sp = 1:ns
        dfyp          = nderivs.dfyp{sp,s};
        dfy           = nderivs.dfy{sp,s};
        dfx           = nderivs.dfx{sp,s};
        dfxlag        = nderivs.dfxlag{sp,s};
        dfypyp        = nderivs.dfypyp{sp,s};
        dfypy         = nderivs.dfypy{sp,s};
        dfypx         = nderivs.dfypx{sp,s};
        dfypxlag      = nderivs.dfypxlag{sp,s};
        dfyy          = nderivs.dfyy{sp,s};
        dfyx          = nderivs.dfyx{sp,s};
        dfyxlag       = nderivs.dfyxlag{sp,s};
        dfxx          = nderivs.dfxx{sp,s};
        dfxxlag       = nderivs.dfxxlag{sp,s};
        dfxlagxlag    = nderivs.dfxlagxlag{sp,s};
                
        Mxx{sp,s} = Pmatss(s,sp)*[kron(eye(nx*nx),dfx+dfyp*G(:,1:nx,sp)) kron(eye(nx*nx),dfy) zeros(n*nx*nx,nx*nx*ny)];
        for ii = 1:nx
            for jj = 1:nx
                Mxx{sp,s}((ii-1)*n*nx+(jj-1)*n+1:(ii-1)*n*nx+jj*n,n*nx*nx+1:end) = Pmatss(s,sp)*kron(kron(H(:,ii,s)',H(:,jj,s)'),dfyp);
            end
        end
        
        Nxx{sp,s} = zeros(n*nx*nx,1);
        for bb = 1:nx
            for cc = 1:nx
                for aa = 1:n
                    loc = (bb-1)*n*nx + (cc-1)*n + aa;
                    Nxx{sp,s}(loc) = 0;          
                    for ii = 1:ny  
                        Nxx{sp,s}(loc) = Nxx{sp,s}(loc) ...
                            + Pmatss(s,sp)*(reshape(dfypyp(aa,ii,:),1,[])*G(:,1:nx,sp)*H(:,cc,s) + reshape(dfypy(aa,ii,:),1,[])*G(:,cc,s) + reshape(dfypx(aa,ii,:),1,[])*H(:,cc,s) + reshape(dfypxlag(aa,ii,cc),1,[]))*G(ii,1:nx,sp)*H(:,bb,s) ...
                            + Pmatss(s,sp)*(reshape(dfypy(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,cc,s)  + reshape(dfyy(aa,ii,:),1,[])*G(:,cc,s)  + reshape(dfyx(aa,ii,:),1,[])*H(:,cc,s)  + reshape(dfyxlag(aa,ii,cc),1,[]))*G(ii,bb,s);
                    end
                    for ii = 1:nx
                       Nxx{sp,s}(loc) = Nxx{sp,s}(loc) ...
                           + Pmatss(s,sp)*(reshape(dfypx(aa,:,ii),1,[])*G(:,1:nx,sp)*H(:,cc,s) + reshape(dfyx(aa,:,ii),1,[])*G(:,cc,s) + reshape(dfxx(aa,:,ii),1,[])*H(:,cc,s) + reshape(dfxxlag(aa,ii,cc),1,[]))*H(ii,bb,s);
                    end
                    Nxx{sp,s}(loc) = Nxx{sp,s}(loc) ...
                        + Pmatss(s,sp)*(reshape(dfypxlag(aa,:,bb),1,[])*G(:,1:nx,sp)*H(:,cc,s) + dfyxlag(aa,:,bb)*G(:,cc,s) + dfxxlag(aa,:,bb)*H(:,cc,s) + dfxlagxlag(aa,bb,cc)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,cc,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,bb,s) + dfy(aa,:)*G(:,bb,s) + dfx(aa,:)*H(:,bb,s) + dfxlag(aa,bb)) ...
                        + shiftdim(dPy(s,sp,:),1)*G(:,bb,s)*(dfyp(aa,:)*G(:,1:nx,sp)*H(:,cc,s) + dfy(aa,:)*G(:,cc,s) + dfx(aa,:)*H(:,cc,s) + dfxlag(aa,cc));
                end
            end
        end
    end
end

